/*
 * vim: filetype=c:tabstop=4:ai:expandtab
 * SPDX-License-Identifier: ICU
 * scspell-id: b8504548-f62e-11ec-a07d-80ee73e9b8e7
 *
 * ---------------------------------------------------------------------------
 *
 * Copyright (c) 2007-2013 Michael Mondy
 * Copyright (c) 2012-2016 Harry Reed
 * Copyright (c) 2013-2016 Charles Anthony
 * Copyright (c) 2021-2023 The DPS8M Development Team
 *
 * All rights reserved.
 *
 * This software is made available under the terms of the ICU
 * License, version 1.8.1 or later.  For more details, see the
 * LICENSE.md file at the top-level directory of this distribution.
 *
 * ---------------------------------------------------------------------------
 */

#include "dps8.h"
#include "dps8_opcodetable.h"

#define _EIS_ NO_TAG | NO_XED | NO_RPT | IGN_B29

struct opcode_s opcodes10[02000] = {
// NonEIS
    /* 000 */
    {NULL,     0,                                         0,                   0, 0},
    {"mme",    PREPARE_CA | NO_RPT,                       0,                   0, 0},
    {"drl",    PREPARE_CA | NO_RPT,                       0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"mme2",   PREPARE_CA | NO_BAR | NO_RPT,              0,                   0, 0},
    {"mme3",   PREPARE_CA | NO_BAR | NO_RPT,              0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"mme4",   PREPARE_CA | NO_BAR | NO_RPT,              0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"nop",    PREPARE_CA | NO_RPT,                       0,                   0, ru_none},
    {"puls1",  PREPARE_CA | NO_RPT,                       0,                   0, 0},
    {"puls2",  PREPARE_CA | NO_RPT,                       0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"cioc",   READ_OPERAND | PRIV_INS | NO_RPT,          NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"adlx0",  READ_OPERAND | NO_RPT,                     NO_CSS,              0, ru_A | ru_X0},
    {"adlx1",  READ_OPERAND,                              NO_CSS,              0, ru_A | ru_X1},
    {"adlx2",  READ_OPERAND,                              NO_CSS,              0, ru_A | ru_X2},
    {"adlx3",  READ_OPERAND,                              NO_CSS,              0, ru_A | ru_X3},
    {"adlx4",  READ_OPERAND,                              NO_CSS,              0, ru_A | ru_X4},
    {"adlx5",  READ_OPERAND,                              NO_CSS,              0, ru_A | ru_X5},
    {"adlx6",  READ_OPERAND,                              NO_CSS,              0, ru_A | ru_X6},
    {"adlx7",  READ_OPERAND,                              NO_CSS,              0, ru_A | ru_X7},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"ldqc",   RMW,                                       NO_DDCSS,            0, ru_Q},
    {"adl",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {"ldac",   RMW,                                       NO_DDCSS,            0, ru_A},
    {"adla",   READ_OPERAND,                              0,                   0, ru_A},
    {"adlq",   READ_OPERAND,                              0,                   0, ru_Q},
    {"adlaq",  READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {"asx0",   RMW | NO_RPT | NO_RPL,                     NO_DDCSS,            0, ru_X0},
    {"asx1",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X1},
    {"asx2",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X2},
    {"asx3",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X3},
    {"asx4",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X4},
    {"asx5",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X5},
    {"asx6",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X6},
    {"asx7",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X7},
    {"adwp0",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DLCSS,            0, 0},
    {"adwp1",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DLCSS,            0, 0},
    {"adwp2",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DLCSS,            0, 0},
    {"adwp3",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DLCSS,            0, 0},
    {"aos",    RMW | NO_RPL,                              NO_DDCSS,            0, ru_none},
    {"asa",    RMW | NO_RPL,                              NO_DDCSS,            0, ru_A},
    {"asq",    RMW | NO_RPL,                              NO_DDCSS,            0, ru_Q},
    {"sscr",   PREPARE_CA | PRIV_INS,                     NO_DDCSS,            0, ru_AQ},
    {"adx0",   READ_OPERAND | NO_RPT,                     NO_CSS,              0, ru_X0},
    {"adx1",   READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"adx2",   READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"adx3",   READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"adx4",   READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"adx5",   READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"adx6",   READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"adx7",   READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {NULL,     0,                                         0,                   0, 0},
    {"awca",   READ_OPERAND,                              0,                   0, ru_A},
    {"awcq",   READ_OPERAND,                              0,                   0, ru_Q},
    {"lreg",   READ_YBLOCK8 | NO_RPT,                     NO_DDCSS,            0, MASK10},
    {NULL,     0,                                         0,                   0, 0},
    {"ada",    READ_OPERAND,                              0,                   0, ru_A},
    {"adq",    READ_OPERAND,                              0,                   0, ru_Q},
    {"adaq",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},

    /* 100 */
    {"cmpx0",  READ_OPERAND | NO_RPT,                     NO_CSS,              0, ru_X0},
    {"cmpx1",  READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"cmpx2",  READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"cmpx3",  READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"cmpx4",  READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"cmpx5",  READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"cmpx6",  READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"cmpx7",  READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {NULL,     0,                                         0,                   0, 0},
    {"cwl",    READ_OPERAND,                              0,                   0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"cmpa",   READ_OPERAND,                              0,                   0, ru_A},
    {"cmpq",   READ_OPERAND,                              0,                   0, ru_Q},
    {"cmpaq",  READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {"sblx0",  READ_OPERAND | NO_RPT,                     NO_CSS,              0, ru_X0},
    {"sblx1",  READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"sblx2",  READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"sblx3",  READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"sblx4",  READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"sblx5",  READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"sblx6",  READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"sblx7",  READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"sbla",   READ_OPERAND,                              0,                   0, ru_A},
    {"sblq",   READ_OPERAND,                              0,                   0, ru_Q},
    {"sblaq",  READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {"ssx0",   RMW | NO_RPT | NO_RPL,                     NO_DDCSS,            0, ru_X0},
    {"ssx1",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X1},
    {"ssx2",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X2},
    {"ssx3",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X3},
    {"ssx4",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X4},
    {"ssx5",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X5},
    {"ssx6",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X6},
    {"ssx7",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_X7},
    {"adwp4",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DLCSS,            0, 0},
    {"adwp5",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DLCSS,            0, 0},
    {"adwp6",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DLCSS,            0, 0},
    {"adwp7",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DLCSS,            0, 0},
    {"sdbr",   STORE_YPAIR | PRIV_INS | NO_RPT,           NO_DDCSS,            0, 0},
    {"ssa",    RMW | NO_RPL,                              NO_DDCSS,            0, ru_A},
    {"ssq",    RMW | NO_RPL,                              NO_DDCSS,            0, ru_Q},
    {NULL,     0,                                         0,                   0, 0},
    {"sbx0",   READ_OPERAND | NO_RPT,                     NO_CSS,              0, ru_X0},
    {"sbx1",   READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"sbx2",   READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"sbx3",   READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"sbx4",   READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"sbx5",   READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"sbx6",   READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"sbx7",   READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {NULL,     0,                                         0,                   0, 0},
    {"swca",   READ_OPERAND,                              0,                   0, ru_A},
    {"swcq",   READ_OPERAND,                              0,                   0, ru_Q},
    {"lpri",   READ_YBLOCK16 | NO_BAR | NO_RPT,           NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"sba",    READ_OPERAND,                              0,                   0, ru_A},
    {"sbq",    READ_OPERAND,                              0,                   0, ru_Q},
    {"sbaq",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},

    /* 200 */
    {"cnax0",  READ_OPERAND | NO_RPT,                     NO_CSS,              0, ru_X0},
    {"cnax1",  READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"cnax2",  READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"cnax3",  READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"cnax4",  READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"cnax5",  READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"cnax6",  READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"cnax7",  READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {NULL,     0,                                         0,                   0, 0},
    {"cmk",    READ_OPERAND,                              0,                   0, ru_AQ},
    // XXX AL-39 seems wrong w.r.t absa; it makes no sense as privileged.
    {"absa",   PREPARE_CA | PRIV_INS | NO_RPT,            NO_DDCSS,            0, ru_A},
    {"epaq",   PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, ru_AQ},
    {"sznc",   RMW,                                       NO_DDCSS,            0, ru_none},
    {"cnaa",   READ_OPERAND,                              0,                   0, ru_A},
    {"cnaq",   READ_OPERAND,                              0,                   0, ru_Q},
    {"cnaaq",  READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {"ldx0",   READ_OPERAND | NO_RPT | NO_RPL,            NO_CSS,              0, ru_X0},
    {"ldx1",   READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"ldx2",   READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"ldx3",   READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"ldx4",   READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"ldx5",   READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"ldx6",   READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"ldx7",   READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {"lbar",   READ_OPERAND | NO_RPT | NO_BAR,            NO_CSS,              0, 0},
    {"rsw",    PREPARE_CA | PRIV_INS | NO_RPT,            0,                   0, ru_A},
    {"ldbr",   READ_YPAIR | PRIV_INS | NO_RPT,            NO_DDCSS,            0, 0},
    {"rmcm",   PRIV_INS,                                  NO_DDCSS,            0, ru_AQ},
    {"szn",    READ_OPERAND,                              0,                   0, ru_none},
    {"lda",    READ_OPERAND,                              0,                   0, ru_A},
    {"ldq",    READ_OPERAND,                              0,                   0, ru_Q},
    {"ldaq",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {"orsx0",  RMW | NO_RPT | NO_RPL,                     NO_DDCSS,            0, ru_X0},
    {"orsx1",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X1},
    {"orsx2",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X2},
    {"orsx3",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X3},
    {"orsx4",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X4},
    {"orsx5",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X5},
    {"orsx6",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X6},
    {"orsx7",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X7},
    {"spri0",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spbp1",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spri2",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spbp3",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spri",   STORE_YBLOCK16 | NO_BAR | NO_RPT,          NO_DDCSS,            0, 0},
    {"orsa",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_A},
    {"orsq",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_Q},
    {"lsdp",   READ_YBLOCK16 | PRIV_INS | NO_RPT,         NO_DDCSS,            0, 0},  // not available on a dps8m
    {"orx0",   READ_OPERAND | NO_RPT,                     NO_CSS,              0, ru_X0},
    {"orx1",   READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"orx2",   READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"orx3",   READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"orx4",   READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"orx5",   READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"orx6",   READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"orx7",   READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {"tsp0",   TRANSFER_INS | TSPN_INS | NO_RPT | NO_BAR, NO_DDCSS,            0, 0},
    {"tsp1",   TRANSFER_INS | TSPN_INS | NO_RPT | NO_BAR, NO_DDCSS,            0, 0},
    {"tsp2",   TRANSFER_INS | TSPN_INS | NO_RPT | NO_BAR, NO_DDCSS,            0, 0},
    {"tsp3",   TRANSFER_INS | TSPN_INS | NO_RPT | NO_BAR, NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"ora",    READ_OPERAND,                              0,                   0, ru_A},
    {"orq",    READ_OPERAND,                              0,                   0, ru_Q},
    {"oraq",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},

    /* 300 */
    {"canx0",  READ_OPERAND | NO_RPT,                     NO_CSS,              0, ru_X0},
    {"canx1",  READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"canx2",  READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"canx3",  READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"canx4",  READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"canx5",  READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"canx6",  READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"canx7",  READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {"eawp0",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"easp0",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"eawp2",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"easp2",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"cana",   READ_OPERAND,                              0,                   0, ru_A},
    {"canq",   READ_OPERAND,                              0,                   0, ru_Q},
    {"canaq",  READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {"lcx0",   READ_OPERAND | NO_RPT | NO_RPL,            NO_CSS,              0, ru_X0},
    {"lcx1",   READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"lcx2",   READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"lcx3",   READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"lcx4",   READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"lcx5",   READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"lcx6",   READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"lcx7",   READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {"eawp4",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"easp4",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"eawp6",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"easp6",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"lca",    READ_OPERAND,                              0,                   0, ru_A},
    {"lcq",    READ_OPERAND,                              0,                   0, ru_Q},
    {"lcaq",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {"ansx0",  RMW | NO_RPT | NO_RPL,                     NO_DDCSS,            0, ru_X0},
    {"ansx1",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X1},
    {"ansx2",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X2},
    {"ansx3",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X3},
    {"ansx4",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X4},
    {"ansx5",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X5},
    {"ansx6",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X6},
    {"ansx7",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X7},
    {"epp0",   PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epbp1",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epp2",   PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epbp3",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"stac",   RMW | NO_RPL | NO_BAR,                     NO_DDCSS,            0, ru_A},
    {"ansa",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_A},
    {"ansq",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_Q},
    {"stcd",   STORE_YPAIR | NO_RPT | NO_BAR,             NO_DDCSS,            0, 0},
    {"anx0",   READ_OPERAND | NO_RPT,                     NO_CSS,              0, ru_X0},
    {"anx1",   READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"anx2",   READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"anx3",   READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"anx4",   READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"anx5",   READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"anx6",   READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"anx7",   READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {"epp4",   PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epbp5",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epp6",   PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epbp7",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"ana",    READ_OPERAND,                              0,                   0, ru_A},
    {"anq",    READ_OPERAND,                              0,                   0, ru_Q},
    {"anaq",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},

    /* 400 */
    {NULL,     0,                                         0,                   0, 0},
    {"mpf",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {"mpy",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"cmg",    READ_OPERAND,                              0,                   0, ru_A},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"lde",    READ_OPERAND,                              NO_CSS,              0, ru_none},
    {NULL,     0,                                         0,                   0, 0},
    {"rscr",   PREPARE_CA | PRIV_INS | NO_RPL,            NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"ade",    READ_OPERAND,                              NO_CSS,              0, ru_none},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"ufm",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"dufm",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"fcmg",   READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"dfcmg",  READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {"fszn",   READ_OPERAND,                              NO_CSS,              0, ru_none},
    {"fld",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"dfld",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"ufa",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"dufa",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {"sxl0",   STORE_OPERAND | NO_RPT | NO_RPL,           NO_DDCSS,            0, ru_X0},
    {"sxl1",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X1},
    {"sxl2",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X2},
    {"sxl3",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X3},
    {"sxl4",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X4},
    {"sxl5",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X5},
    {"sxl6",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X6},
    {"sxl7",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X7},
    {"stz",    STORE_OPERAND | NO_RPL,                    NO_DUDL,             0, ru_none},
    {"smic",   PREPARE_CA | PRIV_INS,                     NO_DDCSS,            0, 0},
    {"scpr",   STORE_YPAIR | NO_TAG | PRIV_INS | NO_RPT,  0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"stt",    STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, 0},
    {"fst",    STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_A},
    {"ste",    STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_none},
    {"dfst",   STORE_YPAIR | NO_RPL,                      NO_DDCSS,            0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"fmp",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"dfmp",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"fstr",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_AQ},
    {"frd",    NO_RPL,                                    0,                   0, ru_AQ},
    {"dfstr",  STORE_YPAIR | NO_RPL,                      NO_DDCSS,            0, ru_AQ},
    {"dfrd",   NO_RPL,                                    0,                   0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"fad",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"dfad",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},

    /* 500 */
    {"rpl",    NO_TAG | NO_RPT,                           0,                   0, ru_X0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"bcd",    READ_OPERAND | NO_RPL,                     NO_CSS,              0, ru_AQ},
    {"div",    READ_OPERAND,                              0,                   0, ru_AQ},
    {"dvf",    READ_OPERAND,                              0,                   0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"fneg",   NO_RPL,                                    0,                   0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"fcmp",   READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"dfcmp",  READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {"rpt",    NO_TAG | NO_RPT,                           0,                   0, ru_X0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"fdi",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"dfdi",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"neg",    NO_RPL,                                    0,                   0, ru_A},
    {"cams",   PREPARE_CA | PRIV_INS | NO_RPT,            NO_DDCSS,            0, 0},
    {"negl",   NO_RPL,                                    0,                   0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"ufs",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"dufs",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {"sprp0",  STORE_OPERAND | NO_BAR | NO_RPT,           NO_DDCSS,            0, 0},
    {"sprp1",  STORE_OPERAND | NO_BAR | NO_RPT,           NO_DDCSS,            0, 0},
    {"sprp2",  STORE_OPERAND | NO_BAR | NO_RPT,           NO_DDCSS,            0, 0},
    {"sprp3",  STORE_OPERAND | NO_BAR | NO_RPT,           NO_DDCSS,            0, 0},
    {"sprp4",  STORE_OPERAND | NO_BAR | NO_RPT,           NO_DDCSS,            0, 0},
    {"sprp5",  STORE_OPERAND | NO_BAR | NO_RPT,           NO_DDCSS,            0, 0},
    {"sprp6",  STORE_OPERAND | NO_BAR | NO_RPT,           NO_DDCSS,            0, 0},
    {"sprp7",  STORE_OPERAND | NO_BAR | NO_RPT,           NO_DDCSS,            0, 0},
    {"sbar",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, 0},
    {"stba",   STORE_OPERAND | NO_TAG | NO_RPT,           0,                   0, ru_A},
    {"stbq",   STORE_OPERAND | NO_TAG | NO_RPT,           0,                   0, ru_Q},
    {"smcm",   PREPARE_CA | PRIV_INS | NO_RPL,            NO_DDCSS,            0, 0},
    {"stc1",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"ssdp",   STORE_YBLOCK16 | PRIV_INS | NO_RPT,        NO_DDCSS,            0, 0},
    {"rpd",    NO_TAG | NO_RPT,                           0,                   0, ru_X0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"fdv",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"dfdv",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"fno",    NO_RPL,                                    0,                   0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"fsb",    READ_OPERAND,                              NO_CSS,              0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"dfsb",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},
    /* 600 */
    {"tze",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_none},
    {"tnz",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_none},
    {"tnc",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_none},
    {"trc",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_none},
    {"tmi",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_none},
    {"tpl",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_none},
    {NULL,     0,                                         0,                   0, 0},
    {"ttf",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_none},
    {"rtcd",   NO_RPT | NO_BAR,                           NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"rcu",    READ_YBLOCK8 | PRIV_INS | NO_RPT,          NO_DDCSS,            0, 0},
    {"teo",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_none},
    {"teu",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_none},
    {"dis",    PRIV_INS | NO_RPT,                         0,                   0, 0},
    {"tov",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_none},
    {"eax0",   PREPARE_CA | NO_RPT | NO_RPL,              NO_DUDL,             0, ru_X0},
    {"eax1",   PREPARE_CA | NO_RPL,                       NO_DUDL,             0, ru_X1},
    {"eax2",   PREPARE_CA | NO_RPL,                       NO_DUDL,             0, ru_X2},
    {"eax3",   PREPARE_CA | NO_RPL,                       NO_DUDL,             0, ru_X3},
    {"eax4",   PREPARE_CA | NO_RPL,                       NO_DUDL,             0, ru_X4},
    {"eax5",   PREPARE_CA | NO_RPL,                       NO_DUDL,             0, ru_X5},
    {"eax6",   PREPARE_CA | NO_RPL,                       NO_DUDL,             0, ru_X6},
    {"eax7",   PREPARE_CA | NO_RPL,                       NO_DUDL,             0, ru_X7},
    {"ret",    NO_RPT,                                    NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"rccl",   PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"ldi",    READ_OPERAND | NO_RPT,                     NO_CSS,              0, ru_none},
    {"eaa",    PREPARE_CA | NO_RPL,                       NO_DUDL,             0, ru_A},
    {"eaq",    PREPARE_CA | NO_RPL,                       NO_DUDL,             0, ru_Q},
    {"ldt",    READ_OPERAND | PRIV_INS | NO_RPT,          NO_CSS,              0, 0},
    {"ersx0",  RMW | NO_RPT | NO_RPL,                     NO_DDCSS,            0, ru_X0},
    {"ersx1",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X1},
    {"ersx2",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X2},
    {"ersx3",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X3},
    {"ersx4",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X4},
    {"ersx5",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X5},
    {"ersx6",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X6},
    {"ersx7",  RMW | NO_RPL,                              NO_DDCSS,            0, ru_X7},
    {"spri4",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spbp5",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spri6",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spbp7",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"stacq",  RMW | NO_RPL | NO_BAR,                     NO_DDCSS,            0, ru_AQ},
    {"ersa",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_A},
    {"ersq",   RMW | NO_RPL,                              NO_DDCSS,            0, ru_Q},
    {"scu",    STORE_YBLOCK8 | PRIV_INS | NO_RPT,         NO_DDCSS,            0, 0},
    {"erx0",   READ_OPERAND | NO_RPT,                     NO_CSS,              0, ru_X0},
    {"erx1",   READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"erx2",   READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"erx3",   READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"erx4",   READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"erx5",   READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"erx6",   READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"erx7",   READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {"tsp4",   TRANSFER_INS | TSPN_INS | NO_RPT | NO_BAR, NO_DDCSS,            0, 0},
    {"tsp5",   TRANSFER_INS | TSPN_INS | NO_RPT | NO_BAR, NO_DDCSS,            0, 0},
    {"tsp6",   TRANSFER_INS | TSPN_INS | NO_RPT | NO_BAR, NO_DDCSS,            0, 0},
    {"tsp7",   TRANSFER_INS | TSPN_INS | NO_RPT | NO_BAR, NO_DDCSS,            0, 0},
    {"lcpr",   READ_OPERAND | NO_TAG | PRIV_INS | NO_RPT, 0,                   0, 0},
    {"era",    READ_OPERAND,                              0,                   0, ru_A},
    {"erq",    READ_OPERAND,                              0,                   0, ru_Q},
    {"eraq",   READ_YPAIR,                                NO_DDCSS,            0, ru_AQ},

    /* 700 */
    {"tsx0",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_X0},
    {"tsx1",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_X1},
    {"tsx2",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_X2},
    {"tsx3",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_X3},
    {"tsx4",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_X4},
    {"tsx5",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_X5},
    {"tsx6",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_X6},
    {"tsx7",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, ru_X7},
    {"tra",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    // CALL6 must fetch the destination instruction to force do_append_cycle
    // to do all of the ring checks and processing.
    //{"call6", PREPARE_CA | TRANSFER_INS | CALL6_INS | NO_RPT, NO_DDCSS, 0},
    {"call6",  TRANSFER_INS | CALL6_INS | NO_RPT,         NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"tss",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, 0},
    {"xec",    READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, 0},
    {"xed",    READ_YPAIR | NO_RPT,                       NO_DDCSS,            0, 0},            // ????
    {"lxl0",   READ_OPERAND | NO_RPT | NO_RPL,            NO_CSS,              0, ru_X0},
    {"lxl1",   READ_OPERAND,                              NO_CSS,              0, ru_X1},
    {"lxl2",   READ_OPERAND,                              NO_CSS,              0, ru_X2},
    {"lxl3",   READ_OPERAND,                              NO_CSS,              0, ru_X3},
    {"lxl4",   READ_OPERAND,                              NO_CSS,              0, ru_X4},
    {"lxl5",   READ_OPERAND,                              NO_CSS,              0, ru_X5},
    {"lxl6",   READ_OPERAND,                              NO_CSS,              0, ru_X6},
    {"lxl7",   READ_OPERAND,                              NO_CSS,              0, ru_X7},
    {NULL,     0,                                         0,                   0, 0},
    {"ars",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_A},
    {"qrs",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_Q},
    {"lrs",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_AQ},
    {NULL,     0,                                         0,                   0, 0},
    {"als",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_A},
    {"qls",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_Q},
    {"lls",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_AQ},
    {"stx0",   STORE_OPERAND | NO_RPT | NO_RPL,           NO_DDCSS,            0, ru_X0},
    {"stx1",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X1},
    {"stx2",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X2},
    {"stx3",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X3},
    {"stx4",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X4},
    {"stx5",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X5},
    {"stx6",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X6},
    {"stx7",   STORE_OPERAND | NO_RPL,                    NO_DDCSS,            0, ru_X7},
    {"stc2",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, 0},
    {"stca",   STORE_OPERAND | NO_TAG | NO_RPT,           0,                   0, ru_A},
    {"stcq",   STORE_OPERAND | NO_TAG | NO_RPT,           0,                   0, ru_Q},
    {"sreg",   STORE_YBLOCK8 | NO_RPT,                    NO_DDCSS,            0, MASK10},
    {"sti",    STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, 0},
    {"sta",    STORE_OPERAND | NO_RPL,                    NO_DUDL,             0, ru_A},
    {"stq",    STORE_OPERAND | NO_RPL,                    NO_DUDL,             0, ru_Q},
    {"staq",   STORE_YPAIR | NO_RPL,                      NO_DDCSS,            0, ru_AQ},
    {"lprp0",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DDCSS,            0, 0},
    {"lprp1",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DDCSS,            0, 0},
    {"lprp2",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DDCSS,            0, 0},
    {"lprp3",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DDCSS,            0, 0},
    {"lprp4",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DDCSS,            0, 0},
    {"lprp5",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DDCSS,            0, 0},
    {"lprp6",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DDCSS,            0, 0},
    {"lprp7",  READ_OPERAND | NO_BAR | NO_RPT,            NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"arl",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_A},
    {"qrl",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_Q},
    {"lrl",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_AQ},
    {"gtb",    PREPARE_CA | NO_RPL,                       0,                   0, ru_A},
    {"alr",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_A},
    {"qlr",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_Q},
    {"llr",    PREPARE_CA | NO_RPL,                       NO_DDCSS,            0, ru_AQ},
// EIS
     /* 000 - 017 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 020 - 037 */
    {"mve",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"mvne",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 040 - 057 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 060 - 077 */
    {"csl",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {"csr",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"sztl",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {"sztr",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {"cmpb",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 100 - 117 */
    {"mlr",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {"mrl",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"cmpc",   _EIS_ | EOP1_ALPHA | EOP2_ALPHA,           0,                   2, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 120 - 137 */
    {"scd",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {"scdr",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"scm",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {"scmr",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 140 - 157 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"sptr",   STORE_YBLOCK16 | PRIV_INS | NO_RPT,        NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 167 - 177 */
    {"mvt",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"tct",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {"tctr",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"lptr",   READ_YBLOCK16 | PRIV_INS | NO_RPT,         NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 200 - 217 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"ad2d",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {"sb2d",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"mp2d",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {"dv2d",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 220 - 237 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"ad3d",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {"sb3d",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"mp3d",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {"dv3d",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   3, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"lsdr",   READ_YBLOCK32 | PRIV_INS | NO_RPT,         NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 240 - 257 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"spbp0",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spri1",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spbp2",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spri3",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"ssdr",   STORE_YBLOCK32 | PRIV_INS | NO_RPT,        NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"lptp",   READ_YBLOCK16 | PRIV_INS | NO_RPT,         NO_DDCSS,            0, 0},
     /* 260 - 277 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 300 - 317 */
    {"mvn",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {"btd",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {"cmpn",   NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {"dtb",    NO_TAG | NO_XED | NO_RPT | IGN_B29,        0,                   2, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"easp1",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"eawp1",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"easp3",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"eawp3",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 320 - 337 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"easp5",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"eawp5",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"easp7",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"eawp7",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 340 - 357 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"epbp0",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epp1",   PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epbp2",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epp3",   PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 360 - 377 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"epbp4",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epp5",   PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epbp6",  PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {"epp7",   PREPARE_CA | NO_BAR | NO_RPT,              NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 400 - 417 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 420 - 437 */
    {"emcall", IGN_B29,                                   0,                   0, 0},            // 420 simulator escape
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 440 - 457 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"sareg",  STORE_YBLOCK8 | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"spl",    STORE_YBLOCK8 | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 460 - 477 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"lareg",  READ_YBLOCK8 | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"lpl",    READ_YBLOCK8 | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 500 - 517 */
    {"a9bd",   IGN_B29 | NO_RPT,                          ONLY_AU_QU_AL_QL_XN, 0, is_9},
    {"a6bd",   IGN_B29 | NO_RPT,                          ONLY_AU_QU_AL_QL_XN, 0, is_6},
    {"a4bd",   IGN_B29 | NO_RPT,                          ONLY_AU_QU_AL_QL_XN, 0, is_4},
    {"abd",    IGN_B29 | NO_RPT,                          ONLY_AU_QU_AL_QL_XN, 0, is_1},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"awd",    IGN_B29 | NO_RPT,                          ONLY_AU_QU_AL_QL_XN, 0, is_WRD},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 520 - 537 */
    {"s9bd",   IGN_B29 | NO_RPT,                          ONLY_AU_QU_AL_QL_XN, 0, is_9},
    {"s6bd",   IGN_B29 | NO_RPT,                          ONLY_AU_QU_AL_QL_XN, 0, is_6},
    {"s4bd",   IGN_B29 | NO_RPT,                          ONLY_AU_QU_AL_QL_XN, 0, is_4},
    {"sbd",    IGN_B29 | NO_RPT,                          ONLY_AU_QU_AL_QL_XN, 0, is_1},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"swd",    IGN_B29 | NO_RPT,                          ONLY_AU_QU_AL_QL_XN, 0, is_WRD},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"camp",   PREPARE_CA | PRIV_INS | NO_RPT,            NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 540 - 557 */
    {"ara0",   RMW | NO_RPT,                              NO_DDCSS,            0, is_DU},
    {"ara1",   RMW | NO_RPT,                              NO_DDCSS,            0, is_DU},
    {"ara2",   RMW | NO_RPT,                              NO_DDCSS,            0, is_DU},
    {"ara3",   RMW | NO_RPT,                              NO_DDCSS,            0, is_DU},
    {"ara4",   RMW | NO_RPT,                              NO_DDCSS,            0, is_DU},
    {"ara5",   RMW | NO_RPT,                              NO_DDCSS,            0, is_DU},
    {"ara6",   RMW | NO_RPT,                              NO_DDCSS,            0, is_DU},
    {"ara7",   RMW | NO_RPT,                              NO_DDCSS,            0, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"sptp",   STORE_YBLOCK16 | PRIV_INS | NO_RPT,        NO_DDCSS,            0, 0},
     /* 560 - 577 */
    {"aar0",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"aar1",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"aar2",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"aar3",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"aar4",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"aar5",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"aar6",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"aar7",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 600 - 617 */
    {"trtn",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, 0},
    {"trtf",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"tmoz",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, 0},
    {"tpnz",   TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, 0},
    {"ttn",    TRANSFER_INS | NO_RPT,                     NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 620 - 637 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 640 - 657 */
    {"arn0",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"arn1",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"arn2",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"arn3",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"arn4",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"arn5",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"arn6",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"arn7",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"spbp4",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spri5",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spbp6",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {"spri7",  STORE_YPAIR | NO_BAR | NO_RPT,             NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 660 - 677 */
    {"nar0",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"nar1",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"nar2",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"nar3",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"nar4",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"nar5",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"nar6",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"nar7",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 700 - 717 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 720 - 737 */
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 740 - 757 */
    {"sar0",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"sar1",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"sar2",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"sar3",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"sar4",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"sar5",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"sar6",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {"sar7",   STORE_OPERAND | NO_RPT,                    NO_DDCSS,            0, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"sra",    STORE_OPERAND | NO_BAR | NO_RPT,           NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
     /* 760 - 777 */
    {"lar0",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"lar1",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"lar2",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"lar3",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"lar4",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"lar5",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"lar6",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {"lar7",   READ_OPERAND | NO_RPT,                     NO_DDCSS,            0, is_DU},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {"lra",    READ_OPERAND | PRIV_INS | NO_RPT,          NO_DDCSS,            0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0},
    {NULL,     0,                                         0,                   0, 0}
};

struct adrMods extMods[0100] = {    ///< address modifiers w/ extended info
    /* R */
    {"",       0,                                         0},
    {"au",     1,                                         0},
    {"qu",     2,                                         0},
    {"du",     3,                                         0},
    {"ic",     4,                                         0},
    {"al",     5,                                         0},
    {"ql",     6,                                         0},
    {"dl",     7,                                         0},
    {"0",      8,                                         0},
    {"1",      9,                                         0},
    {"2",      10,                                        0},
    {"3",      11,                                        0},
    {"4",      12,                                        0},
    {"5",      13,                                        0},
    {"6",      14,                                        0},
    {"7",      15,                                        0},

    /* RI */
    {"n*",     16,                                        0},
    {"au*",    17,                                        0},
    {"qu*",    18,                                        0},
    {NULL,     19,                                        0},
    {"ic*",    20,                                        0},
    {"al*",    21,                                        0},
    {"ql*",    22,                                        0},
    {NULL,     23,                                        0},
    {"0*",     24,                                        0},
    {"1*",     25,                                        0},
    {"2*",     26,                                        0},
    {"3*",     27,                                        0},
    {"4*",     28,                                        0},
    {"5*",     29,                                        0},
    {"6*",     30,                                        0},
    {"7*",     31,                                        0},

    /* IT */
    {"f1",     32,                                        0},
    {"itp",    33,                                        0},
    {NULL,     34,                                        0},
    {"its",    35,                                        0},
    {"sd",     36,                                        0},
    {"scr",    37,                                        0},
    {"f2",     38,                                        0},
    {"f3",     39,                                        0},
    {"ci",     40,                                        0},
    {"i",      41,                                        0},
    {"sc",     42,                                        0},
    {"ad",     43,                                        0},
    {"di",     44,                                        0},
    {"dic",    45,                                        0},
    {"id",     46,                                        0},
    {"idc",    47,                                        0},

    /* IR */
    {"*n",     48,                                        0},
    {"*au",    49,                                        0},
    {"*qu",    50,                                        0},
    {"*du",    51,                                        0},
    {"*ic",    52,                                        0},
    {"*al",    53,                                        0},
    {"*ql",    54,                                        0},
    {"*dl",    55,                                        0},
    {"*0",     56,                                        0},
    {"*1",     57,                                        0},
    {"*2",     58,                                        0},
    {"*3",     59,                                        0},
    {"*4",     60,                                        0},
    {"*5",     61,                                        0},
    {"*6",     62,                                        0},
    {"*7",     63,                                        0},
};

char GEBcdToASCII[64] = ///< from pg 271 CPB1004F_GE635pgmRef_Jul69
{
/* 000 - 007 */    '0', '1', '2', '3', '4', '5', '6', '7',
/* 010 - 017 */    '8', '9', '[', '#', '@', ':', '>', '?',
/* 020 - 027 */    ' ', 'A', 'B', 'C', 'D', 'E', 'F', 'G',
/* 030 - 037 */    'H', 'I', '&', '.', ']', '(', '<', '\\',
/* 040 - 047 */    '^', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
/* 050 - 057 */    'Q', 'R', '-', '$', '*', ')', ';', '\'',
/* 060 - 067 */    '+', '/', 'S', 'T', 'U', 'V', 'W', 'X',
/* 070 - 077 */    'Y', 'Z', '_', ',', '%', '=', '"', '!'
};

#ifndef QUIET_UNUSED
char ASCIIToGEBcd[128] =
{
/* 000 - 007 */    -1, -1, -1, -1, -1, -1, -1, -1,
/* 010 - 017 */    -1, -1, -1, -1, -1, -1, -1, -1,
/* 020 - 027 */    -1, -1, -1, -1, -1, -1, -1, -1,
/* 030 - 037 */    -1, -1, -1, -1, -1, -1, -1, -1,
/* 040 - 047 */    16, 63, 62, 11, 43, 60, 26, 47,
/* 050 - 057 */    29, 45, 44, 48, 59, 42, 27, 49,
/* 060 - 067 */     0,  1,  2,  3,  4,  5,  6,  7,
/* 070 - 077 */     8,  9, 13, 46, 30, 61, 14, 15,
/* 100 - 107 */    12, 17, 18, 19, 20, 21, 22, 23,
/* 110 - 117 */    24, 25, 33, 34, 35, 36, 37, 38,
/* 120 - 127 */    39, 40, 41, 50, 51, 52, 53, 54,
/* 130 - 137 */    55, 56, 57, 10, 31, 28, 32, 58,
/* 140 - 147 */    -1, 17, 18, 19, 20, 21, 22, 23,
/* 150 - 157 */    24, 25, 33, 34, 35, 36, 37, 38,
/* 160 - 167 */    39, 40, 41, 50, 51, 52, 53, 54,
/* 170 - 177 */    55, 56, 57, -1, -1, -1, -1, -1,
};
#endif

#ifndef QUIET_UNUSED
char *op0text[512] = {
        // index by upper 9 bits of those opcodes with bit 27 == 0
         NULL,    "mme",    "drl",    NULL,   "mme2",  "mme3",   NULL,   "mme4",
         NULL,    "nop",    "puls1", "puls2",  NULL,   "cioc",   NULL,    NULL,
        "adlx0",  "adlx1",  "adlx2", "adlx3", "adlx4", "adlx5", "adlx6", "adlx7",
         NULL,     NULL,    "ldqc",  "adl",   "ldac",  "adla",  "adlq",  "adlaq",
        "asx0",   "asx1",   "asx2",  "asx3",  "asx4",  "asx5",  "asx6",  "asx7",
        "adwp0",  "adwp1",  "adwp2", "adwp3", "aos",   "asa",   "asq",   "sscr",
        "adx0",   "adx1",   "adx2",  "adx3",  "adx4",  "adx5",  "adx6",  "adx7",
         NULL,    "awca",   "awcq",  "lreg",   NULL,   "ada",   "adq",   "adaq",
        "cmpx0",  "cmpx1",  "cmpx2", "cmpx3", "cmpx4", "cmpx5", "cmpx6", "cmpx7",
         NULL,    "cwl",     NULL,    NULL,    NULL,   "cmpa",  "cmpq",  "cmpaq",
        "sblx0",  "sblx1",  "sblx2", "sblx3", "sblx4", "sblx5", "sblx6", "sblx7",
         NULL,     NULL,     NULL,    NULL,    NULL,   "sbla",  "sblq",  "sblaq",
        "ssx0",   "ssx1",   "ssx2",  "ssx3",  "ssx4",  "ssx5",  "ssx6",  "ssx7",
        "adwp4",  "adwp5",  "adwp6", "adwp7", "sdbr",  "ssa",   "ssq",    NULL,
        "sbx0",   "sbx1",   "sbx2",  "sbx3",  "sbx4",  "sbx5",  "sbx6",  "sbx7",
         NULL,    "swca",   "swcq",  "lpri",   NULL,   "sba",   "sbq",   "sbaq",
        "cnax0",  "cnax1",  "cnax2", "cnax3", "cnax4", "cnax5", "cnax6", "cnax7",
         NULL,    "cmk",    "absa",  "epaq",  "sznc",  "cnaa",  "cnaq",  "cnaaq",
        "ldx0",   "ldx1",   "ldx2",  "ldx3",  "ldx4",  "ldx5",  "ldx6",  "ldx7",
        "lbar",   "rsw",    "ldbr",  "rmcm",  "szn",   "lda",   "ldq",   "ldaq",
        "orsx0",  "orsx1",  "orsx2", "orsx3", "orsx4", "orsx5", "orsx6", "orsx7",
        "spri0",  "spbp1",  "spri2", "spbp3", "spri",  "orsa",  "orsq",  "lsdp",
        "orx0",   "orx1",   "orx2",  "orx3",  "orx4",  "orx5",  "orx6",  "orx7",
        "tsp0",   "tsp1",   "tsp2",  "tsp3",   NULL,   "ora",   "orq",   "oraq",
        "canx0",  "canx1",  "canx2", "canx3", "canx4", "canx5", "canx6", "canx7",
        "eawp0",  "easp0",  "eawp2", "easp2",  NULL,   "cana",  "canq",  "canaq",
        "lcx0",   "lcx1",   "lcx2",  "lcx3",  "lcx4",  "lcx5",  "lcx6",  "lcx7",
        "eawp4",  "easp4",  "eawp6", "easp6",  NULL,   "lca",   "lcq",   "lcaq",
        "ansx0",  "ansx1",  "ansx2", "ansx3", "ansx4", "ansx5", "ansx6", "ansx7",
        "epp0",   "pbp1",   "epp2",  "epbp3", "stac",  "ansa",  "ansq",  "stcd",
        "anx0",   "anx1",   "anx2",  "anx3",  "anx4",  "anx5",  "anx6",  "anx7",
        "epp4",   "epbp5",  "epp6",  "epbp7",  NULL,   "ana",   "anq",   "anaq",
         NULL,    "mpf",    "mpy",    NULL,    NULL,   "cmg",    NULL,    NULL,
         NULL,    "lde",     NULL,   "rscr",   NULL,   "ade",    NULL,    NULL,
         NULL,    "ufm",     NULL,   "dufm",   NULL,   "fcmg",   NULL,   "dfcmg",
        "fszn",   "fld",     NULL,   "dfld",   NULL,   "ufa",    NULL,   "dufa",
        "sxl0",   "sxl1",   "sxl2",  "sxl3",  "sxl4",  "sxl5",  "sxl6",  "sxl7",
        "stz",    "smic",   "scpr",   NULL,    "stt",  "fst",   "ste",   "dfst",
         NULL,    "fmp",     NULL,   "dfmp",   NULL,    NULL,    NULL,    NULL,
        "fstr",   "frd",    "dfstr", "dfrd",   NULL,   "fad",    NULL,   "dfad",
        "rpl",     NULL,     NULL,    NULL,    NULL,   "bcd",   "div",   "dvf",
         NULL,     NULL,     NULL,   "fneg",   NULL,   "fcmp",   NULL,   "dfcmp",
        "rpt",     NULL,     NULL,    NULL,    NULL,   "fdi",    NULL,   "dfdi",
         NULL,    "neg",    "cams",  "negl",   NULL,   "ufs",    NULL,   "dufs",
        "sprp0",  "sprp1",  "sprp2", "sprp3", "sprp4", "sprp5", "sprp6", "sprp7",
        "sbar",   "stba",   "stbq",  "smcm",  "stc1",   NULL,    NULL,   "ssdp",
        "rpd",     NULL,     NULL,    NULL,    NULL,   "fdv",    NULL,   "dfdv",
         NULL,     NULL,     NULL,   "fno",    NULL,   "fsb",    NULL,   "dfsb",
        "tze",    "tnz",    "tnc",   "trc",   "tmi",   "tpl",    NULL,   "ttf",
        "rtcd",    NULL,     NULL,   "rcu",   "teo",   "teu",   "dis",   "tov",
        "eax0",   "eax1",   "eax2",  "eax3",  "eax4",  "eax5",  "eax6",  "eax7",
        "ret",     NULL,     NULL,   "rccl",  "ldi",   "eaa",   "eaq",   "ldt",
        "ersx0",  "ersx1",  "ersx2", "ersx3", "ersx4", "ersx5", "ersx6", "ersx7",
        "spri4",  "spbp5",  "spri6", "spbp7", "stacq", "ersa",  "ersq",  "scu",
        "erx0",   "erx1",   "erx2",  "erx3",  "erx4",  "erx5",  "erx6",  "erx7",
        "tsp4",   "tsp5",   "tsp6",  "tsp7",  "lcpr",  "era",   "erq",   "eraq",
        "tsx0",   "tsx1",   "tsx2",  "tsx3",  "tsx4",  "tsx5",  "tsx6",  "tsx7",
        "tra",     NULL,     NULL,   "call6",  NULL,   "tss",   "xec",   "xed",
        "lxl0",   "lxl1",   "lxl2",  "lxl3",  "lxl4",  "lxl5",  "lxl6",  "lxl7",
         NULL,    "ars",    "qrs",   "lrs",    NULL,   "als",   "qls",   "lls",
        "stx0",   "stx1",   "stx2",  "stx3",  "stx4",  "stx5",  "stx6",  "stx7",
        "stc2",   "stca",   "stcq",  "sreg",  "sti",   "sta",   "stq",   "staq",
        "lprp0",  "lprp1",  "lprp2", "lprp3", "lprp4", "lprp5", "lprp6", "lprp7",
         NULL,    "arl",    "qrl",   "lrl",   "gtb",   "alr",   "qlr",   "llr"
};
#endif

#ifndef QUIET_UNUSED
char *op1text[512] = {
        // index by upper 9 bits of those opcodes with bit 27 == 1
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "mve",     NULL,     NULL,    NULL,   "mvne",   NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "csl",    "csr",     NULL,    NULL,   "sztl",  "sztr",  "cmpb",   NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "mlr",    "mrl",     NULL,    NULL,    NULL,    NULL,   "cmpc",   NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "scd",    "scdr",    NULL,    NULL,   "scm",   "scmr",   NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,   "sptr",   NULL,    NULL,    NULL,
       "mvt",     NULL,     NULL,    NULL,   "tct",   "tctr",   NULL,    NULL,
        NULL,     NULL,     NULL,   "lptr",   NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,    "ad2d",  "sb2d",   NULL,    NULL,   "mp2d",  "dv2d",
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,    "ad3d",  "sb3d",   NULL,    NULL,   "mp3d",  "dv3d",
        NULL,     NULL,    "lsdr",   NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "spbp0",  "spri1",  "spbp2", "spri3", "ssdr",   NULL,    NULL,   "lptp",
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "mvn",    "btd",     NULL,   "cmpn",   NULL,   "dtb",    NULL,    NULL,
       "easp1",  "eawp1",  "easp3", "eawp3",  NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "easp5",  "eawp5",  "easp7", "eawp7",  NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "epbp0",  "epp1",   "epbp2", "epp3",   NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "epbp4",  "epp5",   "epbp6", "epp7",   NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "emcall",  NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,   "sareg",  NULL,    NULL,    NULL,   "spl",
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,   "lareg",  NULL,    NULL,    NULL,   "lpl",
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "a9bd",   "a6bd",   "a4bd",  "abd",    NULL,    NULL,    NULL,   "awd",
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "s9bd",   "s6bd",   "s4bd",  "sbd",    NULL,    NULL,    NULL,   "swd",
        NULL,     NULL,    "camp",   NULL,    NULL,    NULL,    NULL,    NULL,
       "ara0",   "ara1",   "ara2",  "ara3",  "ara4",  "ara5",  "ara6",  "ara7",
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,   "sptp",
       "aar0",   "aar1",   "aar2",  "aar3",  "aar4",  "aar5",  "aar6",  "aar7",
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "trtn",   "trtf",    NULL,    NULL,   "tmoz",  "tpnz",  "ttn",    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "arn0",   "arn1",   "arn2",  "arn3",  "arn4",  "arn5",  "arn6",  "arn7",
       "spbp4",  "spri5",  "spbp6", "spri7",  NULL,    NULL,    NULL,    NULL,
       "nar0",   "nar1",   "nar2",  "nar3",  "nar4",  "nar5",  "nar6",  "nar7",
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
        NULL,     NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
       "sar0",   "sar1",   "sar2",  "sar3",  "sar4",  "sar5",  "sar6",  "sar7",
        NULL,     NULL,     NULL,    NULL,   "sra",    NULL,    NULL,    NULL,
       "lar0",   "lar1",   "lar2",  "lar3",  "lar4",  "lar5",  "lar6",  "lar7",
        NULL,     NULL,     NULL,    NULL,   "lra",    NULL,    NULL,    NULL
};
#endif

#ifndef QUIET_UNUSED
char *opcodes2text[1024] = {
        // index by all 10 bits of all opcodes
         NULL,    NULL,    "mme",    NULL,   "drl",    NULL,    NULL,    NULL,
        "mme2",   NULL,    "mme3",   NULL,    NULL,    NULL,   "mme4",   NULL,
         NULL,    NULL,    "nop",    NULL,   "puls1",  NULL,   "puls2",  NULL,
         NULL,    NULL,    "cioc",   NULL,    NULL,    NULL,    NULL,    NULL,
        "adlx0", "mve",    "adlx1",  NULL,   "adlx2",  NULL,   "adlx3",  NULL,
        "adlx4", "mvne",   "adlx5",  NULL,   "adlx6",  NULL,   "adlx7",  NULL,
         NULL,    NULL,     NULL,    NULL,   "ldqc",   NULL,   "adl",    NULL,
        "ldac",   NULL,    "adla",   NULL,   "adlq",   NULL,   "adlaq",  NULL,
        "asx0",   NULL,    "asx1",   NULL,   "asx2",   NULL,   "asx3",   NULL,
        "asx4",   NULL,    "asx5",   NULL,   "asx6",   NULL,   "asx7",   NULL,
        "adwp0",  NULL,    "adwp1",  NULL,   "adwp2",  NULL,   "adwp3",  NULL,
        "aos",    NULL,    "asa",    NULL,   "asq",    NULL,   "sscr",   NULL,
        "adx0",  "csl",    "adx1",  "csr",   "adx2",   NULL,   "adx3",   NULL,
        "adx4",  "sztl",   "adx5",  "sztr",  "adx6",  "cmpb",  "adx7",   NULL,
         NULL,    NULL,    "awca",   NULL,   "awcq",   NULL,   "lreg",   NULL,
         NULL,    NULL,    "ada",    NULL,   "adq",    NULL,   "adaq",   NULL,
        "cmpx0", "mlr",    "cmpx1", "mrl",   "cmpx2",  NULL,   "cmpx3",  NULL,
        "cmpx4",  NULL,    "cmpx5",  NULL,   "cmpx6", "cmpc",  "cmpx7",  NULL,
         NULL,    NULL,    "cwl",    NULL,    NULL,    NULL,    NULL,    NULL,
         NULL,    NULL,    "cmpa",   NULL,   "cmpq",   NULL,   "cmpaq",  NULL,
        "sblx0", "scd",    "sblx1", "scdr",  "sblx2",  NULL,   "sblx3",  NULL,
        "sblx4", "scm",    "sblx5", "scmr",  "sblx6",  NULL,   "sblx7",  NULL,
         NULL,    NULL,     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
         NULL,    NULL,    "sbla",   NULL,   "sblq",   NULL,   "sblaq",  NULL,
        "ssx0",   NULL,    "ssx1",   NULL,   "ssx2",   NULL,   "ssx3",   NULL,
        "ssx4",   NULL,    "ssx5",   NULL,   "ssx6",   NULL,   "ssx7",   NULL,
        "adwp4",  NULL,    "adwp5",  NULL,   "adwp6",  NULL,   "adwp7",  NULL,
        "sdbr",  "sptr",   "ssa",    NULL,   "ssq",    NULL,    NULL,    NULL,
        "sbx0",  "mvt",    "sbx1",   NULL,   "sbx2",   NULL,   "sbx3",   NULL,
        "sbx4",  "tct",    "sbx5",  "tctr",  "sbx6",   NULL,   "sbx7",   NULL,
         NULL,    NULL,    "swca",   NULL,   "swcq",   NULL,   "lpri",  "lptr",
         NULL,    NULL,    "sba",    NULL,   "sbq",    NULL,   "sbaq",   NULL,
        "cnax0",  NULL,    "cnax1",  NULL,   "cnax2", "ad2d",  "cnax3", "sb2d",
        "cnax4",  NULL,    "cnax5",  NULL,   "cnax6", "mp2d",  "cnax7", "dv2d",
         NULL,    NULL,    "cmk",    NULL,   "absa",   NULL,   "epaq",   NULL,
        "sznc",   NULL,    "cnaa",   NULL,   "cnaq",   NULL,   "cnaaq",  NULL,
        "ldx0",   NULL,    "ldx1",   NULL,   "ldx2",  "ad3d",  "ldx3",  "sb3d",
        "ldx4",   NULL,    "ldx5",   NULL,   "ldx6",  "mp3d",  "ldx7",  "dv3d",
        "lbar",   NULL,    "rsw",    NULL,   "ldbr",  "lsdr",  "rmcm",   NULL,
        "szn",    NULL,    "lda",    NULL,   "ldq",    NULL,   "ldaq",   NULL,
        "orsx0",  NULL,    "orsx1",  NULL,   "orsx2",  NULL,   "orsx3",  NULL,
        "orsx4",  NULL,    "orsx5",  NULL,   "orsx6",  NULL,   "orsx7",  NULL,
        "spri0", "spbp0",  "spbp1", "spri1", "spri2", "spbp2", "spbp3", "spri3",
        "spri",  "ssdr",   "orsa",   NULL,   "orsq",   NULL,   "lsdp",  "lptp",
        "orx0",   NULL,    "orx1",   NULL,   "orx2",   NULL,   "orx3",   NULL,
        "orx4",   NULL,    "orx5",   NULL,   "orx6",   NULL,   "orx7",   NULL,
        "tsp0",   NULL,    "tsp1",   NULL,   "tsp2",   NULL,   "tsp3",   NULL,
         NULL,    NULL,    "ora",    NULL,   "orq",    NULL,   "oraq",   NULL,
        "canx0", "mvn",    "canx1", "btd",   "canx2",  NULL,   "canx3", "cmpn",
        "canx4",  NULL,    "canx5", "dtb",   "canx6",  NULL,   "canx7",  NULL,
        "eawp0", "easp1",  "easp0", "eawp1", "eawp2", "easp3", "easp2", "eawp3",
         NULL,    NULL,    "cana",   NULL,   "canq",   NULL,   "canaq",  NULL,
        "lcx0",   NULL,    "lcx1",   NULL,   "lcx2",   NULL,   "lcx3",   NULL,
        "lcx4",   NULL,    "lcx5",   NULL,   "lcx6",   NULL,   "lcx7",   NULL,
        "eawp4", "easp5",  "easp4", "eawp5", "eawp6", "easp7", "easp6", "eawp7",
         NULL,    NULL,    "lca",    NULL,   "lcq",    NULL,   "lcaq",   NULL,
        "ansx0",  NULL,    "ansx1",  NULL,   "ansx2",  NULL,   "ansx3",  NULL,
        "ansx4",  NULL,    "ansx5",  NULL,   "ansx6",  NULL,   "ansx7",  NULL,
        "epp0",  "epbp0",  "epbp1", "epp1",  "epp2",  "epbp2", "epbp3", "epp3",
        "stac",   NULL,    "ansa",   NULL,   "ansq",   NULL,   "stcd",   NULL,
        "anx0",   NULL,    "anx1",   NULL,   "anx2",   NULL,   "anx3",   NULL,
        "anx4",   NULL,    "anx5",   NULL,   "anx6",   NULL,   "anx7",   NULL,
        "epp4",  "epbp4",  "epbp5", "epp5",  "epp6",  "epbp6", "epbp7", "epp7",
         NULL,    NULL,    "ana",    NULL,   "anq",    NULL,   "anaq",   NULL,
         NULL,    NULL,    "mpf",    NULL,   "mpy",    NULL,    NULL,    NULL,
         NULL,    NULL,    "cmg",    NULL,    NULL,    NULL,    NULL,    NULL,
         NULL,    NULL,    "lde",    NULL,    NULL,    NULL,   "rscr",   NULL,
         NULL,    NULL,    "ade",    NULL,    NULL,    NULL,    NULL,    NULL,
         NULL,   "emcall", "ufm",    NULL,    NULL,    NULL,   "dufm",   NULL,
         NULL,    NULL,    "fcmg",   NULL,    NULL,    NULL,   "dfcmg",  NULL,
        "fszn",   NULL,    "fld",    NULL,    NULL,    NULL,   "dfld",   NULL,
         NULL,    NULL,    "ufa",    NULL,    NULL,    NULL,   "dufa",   NULL,
        "sxl0",   NULL,    "sxl1",   NULL,   "sxl2",   NULL,   "sxl3",  "sareg",
        "sxl4",   NULL,    "sxl5",   NULL,   "sxl6",   NULL,   "sxl7",  "spl",
        "stz",    NULL,    "smic",   NULL,   "scpr",   NULL,    NULL,    NULL,
        "stt",    NULL,    "fst",    NULL,   "ste",    NULL,   "dfst",   NULL,
         NULL,    NULL,    "fmp",    NULL,    NULL,    NULL,   "dfmp",  "lareg",
         NULL,    NULL,     NULL,    NULL,    NULL,    NULL,    NULL,   "lpl",
        "fstr",   NULL,    "frd",    NULL,   "dfstr",  NULL,   "dfrd",   NULL,
         NULL,    NULL,    "fad",    NULL,    NULL,    NULL,   "dfad",   NULL,
        "rpl",   "a9bd",    NULL,   "a6bd",   NULL,   "a4bd",   NULL,   "abd",
         NULL,    NULL,    "bcd",    NULL,   "div",    NULL,   "dvf",   "awd",
         NULL,    NULL,     NULL,    NULL,    NULL,    NULL,   "fneg",   NULL,
         NULL,    NULL,    "fcmp",   NULL,    NULL,    NULL,   "dfcmp",  NULL,
        "rpt",   "s9bd",    NULL,   "s6bd",   NULL,   "s4bd",   NULL,   "sbd",
         NULL,    NULL,    "fdi",    NULL,    NULL,    NULL,   "dfdi",  "swd",
         NULL,    NULL,    "neg",    NULL,   "cams",  "camp",  "negl",   NULL,
         NULL,    NULL,    "ufs",    NULL,    NULL,    NULL,   "dufs",   NULL,
        "sprp0", "ara0",   "sprp1", "ara1",  "sprp2", "ara2",  "sprp3", "ara3",
        "sprp4", "ara4",   "sprp5", "ara5",  "sprp6", "ara6",  "sprp7", "ara7",
        "sbar",   NULL,    "stba",   NULL,   "stbq",   NULL,   "smcm",   NULL,
        "stc1",   NULL,     NULL,    NULL,    NULL,    NULL,   "ssdp",  "sptp",
        "rpd",   "aar0",    NULL,   "aar1",   NULL,   "aar2",   NULL,   "aar3",
         NULL,   "aar4",   "fdv",   "aar5",   NULL,   "aar6",  "dfdv",  "aar7",
         NULL,    NULL,     NULL,    NULL,    NULL,    NULL,   "fno",    NULL,
         NULL,    NULL,    "fsb",    NULL,    NULL,    NULL,   "dfsb",   NULL,
        "tze",   "trtn",   "tnz",   "trtf",  "tnc",    NULL,   "trc",    NULL,
        "tmi",   "tmoz",   "tpl",   "tpnz",   NULL,   "ttn",   "ttf",    NULL,
        "rtcd",   NULL,     NULL,    NULL,    NULL,    NULL,   "rcu",    NULL,
        "teo",    NULL,    "teu",    NULL,   "dis",    NULL,   "tov",    NULL,
        "eax0",   NULL,    "eax1",   NULL,   "eax2",   NULL,   "eax3",   NULL,
        "eax4",   NULL,    "eax5",   NULL,   "eax6",   NULL,   "eax7",   NULL,
        "ret",    NULL,     NULL,    NULL,    NULL,    NULL,   "rccl",   NULL,
        "ldi",    NULL,    "eaa",    NULL,   "eaq",    NULL,   "ldt",    NULL,
        "ersx0", "arn0",   "ersx1", "arn1",  "ersx2", "arn2",  "ersx3", "arn3",
        "ersx4", "arn4",   "ersx5", "arn5",  "ersx6", "arn6",  "ersx7", "arn7",
        "spri4", "spbp4",  "spbp5", "spri5", "spri6", "spbp6", "spbp7", "spri7",
        "stacq",  NULL,    "ersa",   NULL,   "ersq",   NULL,   "scu",    NULL,
        "erx0",  "nar0",   "erx1",  "nar1",  "erx2",  "nar2",  "erx3",  "nar3",
        "erx4",  "nar4",   "erx5",  "nar5",  "erx6",  "nar6",  "erx7",  "nar7",
        "tsp4",   NULL,    "tsp5",   NULL,   "tsp6",   NULL,   "tsp7",   NULL,
        "lcpr",   NULL,    "era",    NULL,   "erq",    NULL,   "eraq",   NULL,
        "tsx0",   NULL,    "tsx1",   NULL,   "tsx2",   NULL,   "tsx3",   NULL,
        "tsx4",   NULL,    "tsx5",   NULL,   "tsx6",   NULL,   "tsx7",   NULL,
        "tra",    NULL,     NULL,    NULL,    NULL,    NULL,   "call6",  NULL,
         NULL,    NULL,    "tss",    NULL,   "xec",    NULL,   "xed",    NULL,
        "lxl0",   NULL,    "lxl1",   NULL,   "lxl2",   NULL,   "lxl3",   NULL,
        "lxl4",   NULL,    "lxl5",   NULL,   "lxl6",   NULL,   "lxl7",   NULL,
         NULL,    NULL,    "ars",    NULL,   "qrs",    NULL,   "lrs",    NULL,
         NULL,    NULL,    "als",    NULL,   "qls",    NULL,   "lls",    NULL,
        "stx0",  "sar0",   "stx1",  "sar1",  "stx2",  "sar2",  "stx3",  "sar3",
        "stx4",  "sar4",   "stx5",  "sar5",  "stx6",  "sar6",  "stx7",  "sar7",
        "stc2",   NULL,    "stca",   NULL,   "stcq",   NULL,   "sreg",   NULL,
        "sti",   "sra",    "sta",    NULL,   "stq",    NULL,   "staq",   NULL,
        "lprp0", "lar0",   "lprp1", "lar1",  "lprp2", "lar2",  "lprp3", "lar3",
        "lprp4", "lar4",   "lprp5", "lar5",  "lprp6", "lar6",  "lprp7", "lar7",
         NULL,    NULL,    "arl",    NULL,   "qrl",    NULL,   "lrl",    NULL,
        "gtb",   "lra",    "alr",    NULL,   "qlr",    NULL,   "llr",    NULL
};
#endif

#ifdef PANEL68
word8 insGrp [02000] =
  {
// nonEIS
       GRP_UNKN,  GRP_MISC,  GRP_MISC,  GRP_UNKN,  GRP_MISC,  GRP_PSC,   GRP_UNKN,  GRP_MISC,  // 000-007
       GRP_UNKN,  GRP_MISC,  GRP_MISC,  GRP_MISC,  GRP_UNKN,  GRP_PCS,   GRP_UNKN,  GRP_UNKN,  // 010-017
       GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   // 020-027
       GRP_UNKN,  GRP_UNKN,  GRP_FXDML, GRP_FXA,   GRP_FXDML, GRP_FXA,   GRP_FXA,   GRP_FXA,   // 030-037
       GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   // 040-047
       GRP_PRAA,  GRP_PRAA,  GRP_PRAA,  GRP_PRAA,  GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_PSC,   // 050-057
       GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   GRP_FXA,   // 060-067
       GRP_UNKN,  GRP_FXA,   GRP_FXA,   GRP_FXDML, GRP_UNKN,  GRP_FXA,   GRP_FXA,   GRP_FXA,   // 070-077
       GRP_FXC,   GRP_FXC,   GRP_FXC,   GRP_FXC,   GRP_FXC,   GRP_FXC,   GRP_FXC,   GRP_FXC,   // 100-107
       GRP_UNKN,  GRP_FXC,   GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_FXC,   GRP_FXC,   GRP_FXC,   // 110-117
       GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   // 120-127
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_FXS,   GRP_FXS,   GRP_FXS,   // 130-137
       GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   // 140-147
       GRP_PRAA,  GRP_PRAA,  GRP_PRAA,  GRP_PRAA,  GRP_PRS,   GRP_FXS,   GRP_FXS,   GRP_UNKN,  // 150-157
       GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   GRP_FXS,   // 160-167
       GRP_UNKN,  GRP_FXS,   GRP_FXS,   GRP_PRDML, GRP_UNKN,  GRP_FXS,   GRP_FXS,   GRP_FXS,   // 170-177
       GRP_BCN,   GRP_BCN,   GRP_BCN,   GRP_BCN,   GRP_BCN,   GRP_BCN,   GRP_BCN,   GRP_BCN,   // 200-207
       GRP_UNKN,  GRP_FXC,   GRP_PM,    GRP_PRM,   GRP_FXI,   GRP_BCN,   GRP_BCN,   GRP_BCN,   // 210-217
       GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, // 220-227
       GRP_MISC,  GRP_PCS,   GRP_PRL,   GRP_PCS,   GRP_FXI,   GRP_FXDML, GRP_FXDML, GRP_FXDML, // 230-237
       GRP_BO,    GRP_BO,    GRP_BO,    GRP_BO,    GRP_BO,    GRP_BO,    GRP_BO,    GRP_BO,    // 240-247
       GRP_PRDMS, GRP_PRDMS, GRP_PRDMS, GRP_PRDMS, GRP_PRDMS, GRP_BO,    GRP_BO,    GRP_PRL,   // 250-257
       GRP_BO,    GRP_BO,    GRP_BO,    GRP_BO,    GRP_BO,    GRP_BO,    GRP_BO,    GRP_BO,    // 260-267
       GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_UNKN,  GRP_BO,    GRP_BO,    GRP_BO,    // 270-277
       GRP_BCA,   GRP_BCA,   GRP_BCA,   GRP_BCA,   GRP_BCA,   GRP_BCA,   GRP_BCA,   GRP_BCA,   // 300-307
       GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_UNKN,  GRP_BCA,   GRP_BCA,   GRP_BCA,   // 310-317
       GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, // 320-327
       GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_UNKN,  GRP_FXDML, GRP_FXDML, GRP_FXDML, // 330-337
       GRP_BA,    GRP_BA,    GRP_BA,    GRP_BA,    GRP_BA,    GRP_BA,    GRP_BA,    GRP_BA,    // 340-347
       GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_FXDMS, GRP_BA,    GRP_BA,    GRP_FXDMS, // 350-357
       GRP_BA,    GRP_BA,    GRP_BA,    GRP_BA,    GRP_BA,    GRP_BA,    GRP_BA,    GRP_BA,    // 360-367
       GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_UNKN,  GRP_BA,    GRP_BA,    GRP_BA,    // 370-377
       GRP_UNKN,  GRP_FXM,   GRP_FXM,   GRP_UNKN,  GRP_UNKN,  GRP_FXC,   GRP_UNKN,  GRP_UNKN,  // 400-407
       GRP_UNKN,  GRP_FLI,   GRP_UNKN,  GRP_PCS,   GRP_UNKN,  GRP_FLI,   GRP_UNKN,  GRP_UNKN,  // 410-417
       GRP_UNKN,  GRP_FLM,   GRP_UNKN,  GRP_FLM,   GRP_UNKN,  GRP_FLC,   GRP_UNKN,  GRP_FLC,   // 420-427
       GRP_FLI,   GRP_FLDML, GRP_UNKN,  GRP_FLDML, GRP_UNKN,  GRP_FLA,   GRP_UNKN,  GRP_FLA,   // 430-437
       GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, // 440-447
       GRP_FXDMS, GRP_PSC,   GRP_PRS,   GRP_UNKN,  GRP_FXDMS, GRP_FLDMS, GRP_UNKN,  GRP_FLDMS, // 450-457
       GRP_UNKN,  GRP_FLM,   GRP_UNKN,  GRP_FLM,   GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 460-467
       GRP_FLDMS, GRP_FLR,   GRP_FLDMS, GRP_FLR,   GRP_UNKN,  GRP_FLA,   GRP_UNKN,  GRP_FLA,   // 470-477
       GRP_MISC,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_MISC,  GRP_UNKN,  GRP_FXD,   // 500-507
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_FLN,   GRP_UNKN,  GRP_FLC,   GRP_UNKN,  GRP_FLC,   // 510-517
       GRP_MISC,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_FLD,   GRP_UNKN,  GRP_FLD,   // 520-527
       GRP_UNKN,  GRP_FXN,   GRP_PCAM,  GRP_FXN,   GRP_UNKN,  GRP_FLS,   GRP_UNKN,  GRP_FLS,   // 530-537
       GRP_PRDMS, GRP_PRDMS, GRP_PRDMS, GRP_PRDMS, GRP_PRDMS, GRP_PRDMS, GRP_PRDMS, GRP_PRDMS, // 540-547
       GRP_MISC,  GRP_FXDMS, GRP_FXDMS, GRP_PSC,   GRP_FXDMS, GRP_UNKN,  GRP_FLI,   GRP_PRS,   // 550-557
       GRP_MISC,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_FLD,   GRP_UNKN,  GRP_FLD,   // 560-567
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_FLNOR, GRP_UNKN,  GRP_FLS,   GRP_UNKN,  GRP_FLS,   // 570-577
       GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   // 600-607
       GRP_TRA,   GRP_UNKN,  GRP_UNKN,  GRP_PRL,   GRP_TRA,   GRP_TRA,   GRP_PM,    GRP_TRA,   // 610-617
       GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, // 620-627
       GRP_TRA,   GRP_UNKN,  GRP_UNKN,  GRP_MISC,  GRP_UNKN,  GRP_FXDML, GRP_FXDML, GRP_PRL,   // 630-637
       GRP_BE,    GRP_BE,    GRP_BE,    GRP_BE,    GRP_BE,    GRP_BE,    GRP_BE,    GRP_BE,    // 640-647
       GRP_PRDMS, GRP_PRDMS, GRP_PRDMS, GRP_PRDMS, GRP_FXDMS, GRP_BE,    GRP_BE,    GRP_PRS,   // 650-657
       GRP_BE,    GRP_BE,    GRP_BE,    GRP_BE,    GRP_BE,    GRP_BE,    GRP_BE,    GRP_BE,    // 660-667
       GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_PRL,   GRP_BE,    GRP_BE,    GRP_BE,    // 670-677
       GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   GRP_TRA,   // 700-707
       GRP_TRA,   GRP_UNKN,  GRP_UNKN,  GRP_TRA,   GRP_UNKN,  GRP_TRA,   GRP_MISC,  GRP_MISC,  // 710-717
       GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, GRP_FXDML, // 720-727
       GRP_UNKN,  GRP_FXDMR, GRP_FXDMR, GRP_FXDMR, GRP_UNKN,  GRP_FXDMR, GRP_FXDMR, GRP_FXDMR, // 730-737
       GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, // 740-747
       GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, GRP_FXDMS, // 750-757
       GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, // 760-767
       GRP_UNKN,  GRP_FXDMR, GRP_FXDMR, GRP_FXDMR, GRP_MISC,  GRP_FXDMR, GRP_FXDMR, GRP_FXDMR, // 770-777
// EIS
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 000-007
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 010-017
       GRP_EANM,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_ENM,   GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 020-027
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 030-037
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 040-047
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 050-057
       GRP_EBCN,  GRP_EBCN,  GRP_UNKN,  GRP_UNKN,  GRP_EBSI,  GRP_EBSI,  GRP_EBCR,  GRP_UNKN,  // 060-067
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 070-077
       GRP_EANM,  GRP_EANM,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_EANC,  GRP_UNKN,  // 100-107
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 110-117
       GRP_EANC,  GRP_EANC,  GRP_UNKN,  GRP_UNKN,  GRP_EANC,  GRP_EANC,  GRP_UNKN,  GRP_UNKN,  // 120-127
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 130-137
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 140-147
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_PRS,   GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 150-157
       GRP_EANM,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_EANC,  GRP_EANC,  GRP_UNKN,  GRP_UNKN,  // 160-167
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_PRL,   GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 170-177
       GRP_UNKN,  GRP_UNKN,  GRP_EDA,   GRP_EDS,   GRP_UNKN,  GRP_UNKN,  GRP_EDM,   GRP_EDD,   // 200-207
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 210-217
       GRP_UNKN,  GRP_UNKN,  GRP_EDA,   GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_EDM,   GRP_EDD,   // 220-227
       GRP_UNKN,  GRP_UNKN,  GRP_PRL,   GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 230-237
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 240-247
       GRP_PRDMS, GRP_UNKN,  GRP_PRDMS, GRP_UNKN,  GRP_PRS,   GRP_UNKN,  GRP_UNKN,  GRP_PRL,   // 250-257
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 260-267
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 270-277
       GRP_ENM,   GRP_EDC,   GRP_UNKN,  GRP_ENC,   GRP_UNKN,  GRP_EDC,   GRP_UNKN,  GRP_UNKN,  // 300-307
       GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 310-317
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 320-327
       GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 330-337
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 340-347
       GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 350-357
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 360-367
       GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_PRDML, GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 370-377
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 400-407
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 410-417
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 420-427
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 430-437
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_EARS,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_EARS,  // 440-447
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 450-457
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_EARL,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_EARL,  // 460-467
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 470-477
       GRP_EARSA, GRP_EARSA, GRP_EARSA, GRP_EARSA, GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_EARSA, // 500-507
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 510-517
       GRP_EARSA, GRP_EARSA, GRP_EARSA, GRP_EARSA, GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_EARSA, // 520-527
       GRP_UNKN,  GRP_UNKN,  GRP_PCAM,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 530-537
       GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  // 540-547
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_PRS,   // 550-557
       GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  // 560-567
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 570-577
       GRP_TRA,   GRP_TRA,   GRP_UNKN,  GRP_UNKN,  GRP_TRA,   GRP_TRA,   GRP_UNKN,  GRP_UNKN,  // 600-607
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 610-617
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 620-627
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 630-637
       GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  // 640-647
       GRP_PRDMS, GRP_UNKN,  GRP_PRDMS, GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 650-657
       GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  // 660-667
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 670-677
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 700-707
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 710-717
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 720-727
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 730-737
       GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  GRP_EARS,  // 740-747
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_MISC,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 750-757
       GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  GRP_EARL,  // 760-767
       GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  GRP_PRL,   GRP_UNKN,  GRP_UNKN,  GRP_UNKN,  // 770-777
  };
#endif
